/* Bytecode instruction opcodes. */
module.exports = {
  /* Stack Manipulation */

  PUSH:             0,    // PUSH c
  PUSH_CURR_POS:    1,    // PUSH_CURR_POS
  POP:              2,    // POP
  POP_CURR_POS:     3,    // POP_CURR_POS
  POP_N:            4,    // POP_N n
  NIP:              5,    // NIP
  APPEND:           6,    // APPEND
  WRAP:             7,    // WRAP n
  TEXT:             8,    // TEXT

  /* Conditions and Loops */

  IF:               9,    // IF t, f
  IF_ERROR:         10,   // IF_ERROR t, f
  IF_NOT_ERROR:     11,   // IF_NOT_ERROR t, f
  WHILE_NOT_ERROR:  12,   // WHILE_NOT_ERROR b

  /* Matching */

  MATCH_ANY:        13,   // MATCH_ANY a, f, ...
  MATCH_STRING:     14,   // MATCH_STRING s, a, f, ...
  MATCH_STRING_IC:  15,   // MATCH_STRING_IC s, a, f, ...
  MATCH_REGEXP:     16,   // MATCH_REGEXP r, a, f, ...
  ACCEPT_N:         17,   // ACCEPT_N n
  ACCEPT_STRING:    18,   // ACCEPT_STRING s
  FAIL:             19,   // FAIL e

  /* Calls */

  REPORT_SAVED_POS: 20,   // REPORT_SAVED_POS p
  REPORT_CURR_POS:  21,   // REPORT_CURR_POS
  CALL:             22,   // CALL f, n, pc, p1, p2, ..., pN

  /* Rules */

  RULE:             23,   // RULE r

  /* Failure Reporting */

  SILENT_FAILS_ON:  24,   // SILENT_FAILS_ON
  SILENT_FAILS_OFF: 25    // SILENT_FAILS_FF
};
